package ru.yandex.solomon.acl.db.model;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ServiceProviderAclEntry extends DefaultObject {

    private final String serviceProviderId;
    private final String uid;
    private final AclUidType type;
    private Set<String> roles;
    private final int version;

    public ServiceProviderAclEntry(String serviceProviderId, String uid, AclUidType type, Set<String> roles, int version) {
        this.serviceProviderId = serviceProviderId;
        this.uid = uid;
        this.type = type;
        this.roles = roles;
        this.version = version;
    }

    public String getServiceProviderId() {
        return serviceProviderId;
    }

    public String getUid() {
        return uid;
    }

    public AclUidType getType() {
        return type;
    }

    public Set<String> getRoles() {
        return roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public static Id compositeId(String serviceProviderId, String uid, AclUidType type) {
        return new Id(serviceProviderId, uid, type);
    }

    public Id getCompositeId() {
        return compositeId(serviceProviderId, uid, type);
    }

    public int getVersion() {
        return version;
    }

    public static ServiceProviderAclEntry copy(ServiceProviderAclEntry copyFrom) {
        return new ServiceProviderAclEntry(
                copyFrom.serviceProviderId,
                copyFrom.uid,
                copyFrom.type,
                new HashSet<>(copyFrom.roles),
                copyFrom.version);
    }

    public static record Id(String serviceProviderId, String uid,
                            AclUidType type) implements Comparable<ServiceProviderAclEntry.Id> {

        @Override
        public int compareTo(ServiceProviderAclEntry.Id o) {
            int compare = String.CASE_INSENSITIVE_ORDER.compare(serviceProviderId, o.serviceProviderId);
            if (compare != 0) {
                return compare;
            }
            compare = String.CASE_INSENSITIVE_ORDER.compare(uid, o.uid);
            if (compare != 0) {
                return compare;
            }

            return String.CASE_INSENSITIVE_ORDER.compare(type.name(), o.type.name());
        }
    }
}
