package ru.yandex.solomon.acl.db.model;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class SystemAclEntry extends DefaultObject {

    private final String uid;
    private final AclUidType type;
    private Set<String> roles;
    private final int version;

    public SystemAclEntry(String uid, AclUidType type, Set<String> roles, int version) {
        this.uid = uid;
        this.type = type;
        this.roles = roles;
        this.version = version;
    }

    public String getUid() {
        return uid;
    }

    public AclUidType getType() {
        return type;
    }

    public Set<String> getRoles() {
        return roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public static Id compositeId(String uid, AclUidType type) {
        return new Id(uid, type);
    }

    public Id getCompositeId() {
        return compositeId(uid, type);
    }

    public int getVersion() {
        return version;
    }

    public static SystemAclEntry copy(SystemAclEntry copyFrom) {
        return new SystemAclEntry(copyFrom.uid, copyFrom.type, new HashSet<>(copyFrom.roles), copyFrom.version);
    }

    public static record Id(String uid, AclUidType type) implements Comparable<SystemAclEntry.Id> {

        @Override
        public int compareTo(SystemAclEntry.Id o) {
            int compare = String.CASE_INSENSITIVE_ORDER.compare(uid, o.uid);
            if (compare != 0) {
                return compare;
            }

            return String.CASE_INSENSITIVE_ORDER.compare(type.name(), o.type.name());
        }
    }
}
