package ru.yandex.solomon.acl.db.ydb.queries;

/**
 * @author Alexey Trushkin
 */
public class GroupMemberQueries {

    public static final String UPSERT_TEMPLATE = """
            --!syntax_v1
            DECLARE $rows AS %s;

            UPSERT INTO `%s`
            SELECT * FROM AS_TABLE($rows);
            """;

    public static final String FIND_BY_GROUP_ID_TEMPLATE = """
            --!syntax_v1
            DECLARE $groupId AS Utf8;

            SELECT * FROM `%s`
            WHERE groupId = $groupId;
            """;

    public static final String EXIST_BY_GROUP_ID_TEMPLATE = """
            --!syntax_v1
            DECLARE $groupId AS Utf8;

            SELECT TRUE as value FROM `%s`
            WHERE groupId = $groupId LIMIT 1;
            """;

    public static final String DELETE_TEMPLATE = """
             --!syntax_v1
            DECLARE $rows AS %s;

            DELETE FROM `%s` ON SELECT * FROM AS_TABLE($rows);
            """;

    public static final String DELETE_BY_GROUP_TEMPLATE = """
            --!syntax_v1
            DECLARE $groupId AS Utf8;

            DELETE FROM `%s`
            WHERE groupId = $groupId;
            """;
}
