package ru.yandex.solomon.acl.db.ydb.queries;

/**
 * @author Alexey Trushkin
 */
public class ServiceProviderAclEntryQueries {

    public static final String INSERT_TEMPLATE = """
            --!syntax_v1
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $uid AS Utf8;
            DECLARE $type AS Utf8;
            DECLARE $roles AS Utf8;
            DECLARE $version AS Uint32;

            INSERT INTO `%s` (serviceProviderId,uid,type,roles,version)
            VALUES ($serviceProviderId,$uid,$type,$roles,$version);
            """;

    public static final String UPDATE_TEMPLATE = """
            --!syntax_v1
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $uid AS Utf8;
            DECLARE $type AS Utf8;
            DECLARE $roles AS Utf8;
            DECLARE $version AS Uint32;

            $update = (
              SELECT
                serviceProviderId,
                uid,
                type,
                $roles AS roles,
                CAST($version + 1 AS Uint32)   AS version
              FROM `%s`
              WHERE serviceProviderId = $serviceProviderId AND uid = $uid AND type = $type AND version = $version
            );

            SELECT TRUE as value FROM $update;

            UPSERT INTO `%s`
            SELECT * FROM $update;
            """;

    public static final String DELETE_TEMPLATE = """
            --!syntax_v1
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $uid AS Utf8;
            DECLARE $type AS Utf8;
            DECLARE $version AS Uint32;

            SELECT TRUE AS value
            FROM `%s`
            WHERE serviceProviderId = $serviceProviderId AND uid = $uid AND type = $type AND version = $version;

            DELETE FROM `%s`
            WHERE serviceProviderId = $serviceProviderId AND uid = $uid AND type = $type AND version = $version;
            """;

    public static final String FIND_TEMPLATE = """
            --!syntax_v1
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $uid AS Utf8;
            DECLARE $type AS Utf8;

            SELECT * FROM `%s`
             WHERE serviceProviderId = $serviceProviderId AND uid = $uid AND type = $type;
            """;

    public static final String LIST_TEMPLATE = """
            --!syntax_v1
            DECLARE $serviceProviderId AS Utf8;
            DECLARE $pageSize AS Int32;
            DECLARE $pageOffset AS Int32;

            SELECT * FROM `%s`
            WHERE serviceProviderId = $serviceProviderId
            ORDER BY serviceProviderId, uid, type
            LIMIT $pageSize OFFSET $pageOffset;
            """;
}
