package ru.yandex.solomon.acl.db.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.acl.db.AbstractServiceProviderAclEntryDaoTest;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class YdbServiceProviderAclEntryDaoTest extends AbstractServiceProviderAclEntryDaoTest {
    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbServiceProviderAclEntryDao dao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        dao = new YdbServiceProviderAclEntryDao(ydb.getRootPath(), ydb.getTableClient(), ydb.getSchemeClient());
        dao.createSchemaForTests().join();
    }

    @After
    public void tearDown() {
        join(dao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public YdbServiceProviderAclEntryDao getDao() {
        return dao;
    }
}
