package ru.yandex.solomon.alert.client;

import java.util.List;

import com.google.common.net.HostAndPort;

import ru.yandex.grpc.utils.DefaultClientOptions;
import ru.yandex.grpc.utils.GrpcClientOptions;
import ru.yandex.solomon.alert.client.grpc.AlertingCluster;
import ru.yandex.solomon.alert.client.grpc.GrpcAlertingClient;

/**
 * @author Vladimir Gordiychuk
 */
public class AlertingClients {
    private AlertingClients() {
    }

    public static AlertingClient create(List<HostAndPort> addresses) {
        return create(addresses, DefaultClientOptions.empty());
    }

    public static AlertingClient create(List<HostAndPort> addresses, GrpcClientOptions options) {
        return new GrpcAlertingClient(new AlertingCluster(addresses, options));
    }

    public static AlertingClient create(AlertingCluster cluster) {
        return new GrpcAlertingClient(cluster);
    }
}
