package ru.yandex.solomon.alert.client;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.CreateMuteRequest;
import ru.yandex.solomon.alert.protobuf.CreateMuteResponse;
import ru.yandex.solomon.alert.protobuf.DeleteMuteRequest;
import ru.yandex.solomon.alert.protobuf.DeleteMuteResponse;
import ru.yandex.solomon.alert.protobuf.ListMutesRequest;
import ru.yandex.solomon.alert.protobuf.ListMutesResponse;
import ru.yandex.solomon.alert.protobuf.ReadMuteRequest;
import ru.yandex.solomon.alert.protobuf.ReadMuteResponse;
import ru.yandex.solomon.alert.protobuf.ReadMuteStatsRequest;
import ru.yandex.solomon.alert.protobuf.ReadMuteStatsResponse;
import ru.yandex.solomon.alert.protobuf.UpdateMuteRequest;
import ru.yandex.solomon.alert.protobuf.UpdateMuteResponse;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface MuteApi {
    CompletableFuture<CreateMuteResponse> createMute(CreateMuteRequest request, long deadlineMillis);

    CompletableFuture<ReadMuteResponse> readMute(ReadMuteRequest request, long deadlineMillis);

    CompletableFuture<UpdateMuteResponse> updateMute(UpdateMuteRequest request, long deadlineMillis);

    CompletableFuture<DeleteMuteResponse> deleteMute(DeleteMuteRequest request, long deadlineMillis);

    CompletableFuture<ListMutesResponse> listMutes(ListMutesRequest request, long deadlineMillis);

    CompletableFuture<ReadMuteStatsResponse> readMuteStats(ReadMuteStatsRequest request, long deadlineMillis);
}
