package ru.yandex.solomon.alert.client;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.protobuf.TCreateNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TCreateNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TDeleteNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TDeleteNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TListEscalationsRequest;
import ru.yandex.solomon.alert.protobuf.TListEscalationsResponse;
import ru.yandex.solomon.alert.protobuf.TListNotificationsRequest;
import ru.yandex.solomon.alert.protobuf.TListNotificationsResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TResolveNotificationDetailsRequest;
import ru.yandex.solomon.alert.protobuf.TResolveNotificationDetailsResponse;
import ru.yandex.solomon.alert.protobuf.TUpdateNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TUpdateNotificationResponse;

/**
 * @author Vladimir Gordiychuk
 */
public interface NotificationApi {
    CompletableFuture<TCreateNotificationResponse> createNotification(TCreateNotificationRequest request);

    CompletableFuture<TReadNotificationResponse> readNotification(TReadNotificationRequest request);

    CompletableFuture<TUpdateNotificationResponse> updateNotification(TUpdateNotificationRequest request);

    CompletableFuture<TDeleteNotificationResponse> deleteNotification(TDeleteNotificationRequest request);

    CompletableFuture<TListNotificationsResponse> listNotification(TListNotificationsRequest request);

    CompletableFuture<TResolveNotificationDetailsResponse> resolveNotificationDetails(TResolveNotificationDetailsRequest request);

    CompletableFuture<TListEscalationsResponse> listEscalations(TListEscalationsRequest request);
}
