package ru.yandex.solomon.alert.client.grpc;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

import ru.yandex.solomon.alert.client.AlertTemplateApi;
import ru.yandex.solomon.alert.protobuf.CreateAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.CreateAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.DeleteAlertTemplatePublicationRequest;
import ru.yandex.solomon.alert.protobuf.DeleteAlertTemplatePublicationResponse;
import ru.yandex.solomon.alert.protobuf.DeployAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.DeployAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateVersionsRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateVersionsResponse;
import ru.yandex.solomon.alert.protobuf.PublishAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.PublishAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ReadAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.ReadAlertTemplateResponse;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class AlertTemplateClient implements AlertTemplateApi {
    private final AlertingCluster cluster;

    public AlertTemplateClient(@WillNotClose AlertingCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public CompletableFuture<ListAlertTemplateResponse> list(ListAlertTemplateRequest request) {
        return cluster.execute(EndpointDescriptors.METHOD_LIST_TEMPLATES, request);
    }

    @Override
    public CompletableFuture<ListAlertTemplateVersionsResponse> listTemplateVersions(ListAlertTemplateVersionsRequest request) {
        return cluster.execute(EndpointDescriptors.METHOD_LIST_TEMPLATE_VERSIONS, request);
    }

    @Override
    public CompletableFuture<CreateAlertTemplateResponse> create(CreateAlertTemplateRequest request) {
        return cluster.execute(EndpointDescriptors.METHOD_CREATE_TEMPLATE, request);
    }

    @Override
    public CompletableFuture<ReadAlertTemplateResponse> read(ReadAlertTemplateRequest request) {
        return cluster.execute(EndpointDescriptors.METHOD_READ_TEMPLATE, request);
    }

    @Override
    public CompletableFuture<PublishAlertTemplateResponse> publish(PublishAlertTemplateRequest request) {
        return cluster.execute(EndpointDescriptors.METHOD_PUBLISH_TEMPLATE, request);
    }

    @Override
    public CompletableFuture<DeleteAlertTemplatePublicationResponse> unpublish(DeleteAlertTemplatePublicationRequest request) {
        return cluster.execute(EndpointDescriptors.METHOD_UNPUBLISH_TEMPLATE, request);
    }

    @Override
    public CompletableFuture<DeployAlertTemplateResponse> deploy(DeployAlertTemplateRequest request) {
        return cluster.execute(EndpointDescriptors.METHOD_DEPLOY_TEMPLATE, request);
    }
}
