package ru.yandex.solomon.alert.client.grpc;

import ru.yandex.solomon.alert.protobuf.AlertTemplateServiceGrpc;
import ru.yandex.solomon.alert.protobuf.CreateAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.CreateAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateRequest;
import ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateResponse;
import ru.yandex.solomon.alert.protobuf.CreateMuteRequest;
import ru.yandex.solomon.alert.protobuf.CreateMuteResponse;
import ru.yandex.solomon.alert.protobuf.DeleteAlertTemplatePublicationRequest;
import ru.yandex.solomon.alert.protobuf.DeleteAlertTemplatePublicationResponse;
import ru.yandex.solomon.alert.protobuf.DeleteMuteRequest;
import ru.yandex.solomon.alert.protobuf.DeleteMuteResponse;
import ru.yandex.solomon.alert.protobuf.DeployAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.DeployAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ERequestStatusCode;
import ru.yandex.solomon.alert.protobuf.ListAlertLabelsRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertLabelsResponse;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateVersionsRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertTemplateVersionsResponse;
import ru.yandex.solomon.alert.protobuf.ListMutesRequest;
import ru.yandex.solomon.alert.protobuf.ListMutesResponse;
import ru.yandex.solomon.alert.protobuf.MuteServiceGrpc;
import ru.yandex.solomon.alert.protobuf.PublishAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.PublishAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ReadAlertTemplateRequest;
import ru.yandex.solomon.alert.protobuf.ReadAlertTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ReadMuteRequest;
import ru.yandex.solomon.alert.protobuf.ReadMuteResponse;
import ru.yandex.solomon.alert.protobuf.ReadMuteStatsRequest;
import ru.yandex.solomon.alert.protobuf.ReadMuteStatsResponse;
import ru.yandex.solomon.alert.protobuf.TAlertServiceGrpc;
import ru.yandex.solomon.alert.protobuf.TCreateAlertRequest;
import ru.yandex.solomon.alert.protobuf.TCreateAlertResponse;
import ru.yandex.solomon.alert.protobuf.TCreateNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TCreateNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TDeleteAlertRequest;
import ru.yandex.solomon.alert.protobuf.TDeleteAlertResponse;
import ru.yandex.solomon.alert.protobuf.TDeleteNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TDeleteNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TDeletionNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TDeletionNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TExplainEvaluationRequest;
import ru.yandex.solomon.alert.protobuf.TExplainEvaluationResponse;
import ru.yandex.solomon.alert.protobuf.TListAlertRequest;
import ru.yandex.solomon.alert.protobuf.TListAlertResponse;
import ru.yandex.solomon.alert.protobuf.TListEscalationsRequest;
import ru.yandex.solomon.alert.protobuf.TListEscalationsResponse;
import ru.yandex.solomon.alert.protobuf.TListNotificationsRequest;
import ru.yandex.solomon.alert.protobuf.TListNotificationsResponse;
import ru.yandex.solomon.alert.protobuf.TListSubAlertRequest;
import ru.yandex.solomon.alert.protobuf.TListSubAlertResponse;
import ru.yandex.solomon.alert.protobuf.TNotificationServiceGrpc;
import ru.yandex.solomon.alert.protobuf.TReadAlertInterpolatedRequest;
import ru.yandex.solomon.alert.protobuf.TReadAlertInterpolatedResponse;
import ru.yandex.solomon.alert.protobuf.TReadAlertRequest;
import ru.yandex.solomon.alert.protobuf.TReadAlertResponse;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStateRequest;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStateResponse;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStatsRequest;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStateRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStateResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStatsRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadProjectStatsRequest;
import ru.yandex.solomon.alert.protobuf.TReadProjectStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadSubAlertRequest;
import ru.yandex.solomon.alert.protobuf.TReadSubAlertResponse;
import ru.yandex.solomon.alert.protobuf.TResolveNotificationDetailsRequest;
import ru.yandex.solomon.alert.protobuf.TResolveNotificationDetailsResponse;
import ru.yandex.solomon.alert.protobuf.TSimulateEvaluationRequest;
import ru.yandex.solomon.alert.protobuf.TSimulateEvaluationResponse;
import ru.yandex.solomon.alert.protobuf.TTelegramGroupTitlesRequest;
import ru.yandex.solomon.alert.protobuf.TTelegramGroupTitlesResponse;
import ru.yandex.solomon.alert.protobuf.TTelegramServiceGrpc;
import ru.yandex.solomon.alert.protobuf.TUpdateAlertRequest;
import ru.yandex.solomon.alert.protobuf.TUpdateAlertResponse;
import ru.yandex.solomon.alert.protobuf.TUpdateNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TUpdateNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TYaChatsGroupsRequest;
import ru.yandex.solomon.alert.protobuf.TYaChatsGroupsResponse;
import ru.yandex.solomon.alert.protobuf.TYaChatsServiceGrpc;
import ru.yandex.solomon.alert.protobuf.UpdateAlertTemplateVersionRequest;
import ru.yandex.solomon.alert.protobuf.UpdateAlertTemplateVersionResponse;
import ru.yandex.solomon.alert.protobuf.UpdateMuteRequest;
import ru.yandex.solomon.alert.protobuf.UpdateMuteResponse;

/**
 * @author Vladimir Gordiychuk
 */
public class EndpointDescriptors {
    static final EndpointDescriptor<TCreateAlertRequest, TCreateAlertResponse> METHOD_CREATE_ALERT =
            EndpointDescriptor.<TCreateAlertRequest, TCreateAlertResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getCreateAlertMethod())
                    .setDeadlineResolver(TCreateAlertRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TCreateAlertResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TReadAlertRequest, TReadAlertResponse> METHOD_READ_ALERT =
            EndpointDescriptor.<TReadAlertRequest, TReadAlertResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getReadAlertMethod())
                    .setDeadlineResolver(TReadAlertRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TReadAlertResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TReadAlertInterpolatedRequest, TReadAlertInterpolatedResponse> METHOD_READ_INTERPOLATED_ALERT =
            EndpointDescriptor.<TReadAlertInterpolatedRequest, TReadAlertInterpolatedResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getReadAlertInterpolatedMethod())
                    .setDeadlineResolver(TReadAlertInterpolatedRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TReadAlertInterpolatedResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TReadSubAlertRequest, TReadSubAlertResponse> METHOD_READ_SUB_ALERT =
            EndpointDescriptor.<TReadSubAlertRequest, TReadSubAlertResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getReadSubAlertMethod())
                    .setDeadlineResolver(TReadSubAlertRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TReadSubAlertResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TUpdateAlertRequest, TUpdateAlertResponse> METHOD_UPDATE_ALERT =
            EndpointDescriptor.<TUpdateAlertRequest, TUpdateAlertResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getUpdateAlertMethod())
                    .setDeadlineResolver(TUpdateAlertRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TUpdateAlertResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TDeleteAlertRequest, TDeleteAlertResponse> METHOD_DELETE_ALERT =
            EndpointDescriptor.<TDeleteAlertRequest, TDeleteAlertResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getDeleteAlertMethod())
                    .setDeadlineResolver(TDeleteAlertRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TDeleteAlertResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TDeletionNotificationRequest, TDeletionNotificationResponse> METHOD_NOTIFY_PROJECT_DELETED =
            EndpointDescriptor.<TDeletionNotificationRequest, TDeletionNotificationResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getNotifyOnDeletionProjectMethod())
                    .setDeadlineResolver(TDeletionNotificationRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TDeletionNotificationResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TListAlertRequest, TListAlertResponse> METHOD_LIST_ALERTS =
            EndpointDescriptor.<TListAlertRequest, TListAlertResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getListAlertMethod())
                    .setDeadlineResolver(TListAlertRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TListAlertResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TListSubAlertRequest, TListSubAlertResponse> METHOD_LIST_SUB_ALERTS =
            EndpointDescriptor.<TListSubAlertRequest, TListSubAlertResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getListSubAlertMethod())
                    .setDeadlineResolver(value -> 0)
                    .setStatusCodeResolver(TListSubAlertResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TReadEvaluationStateRequest, TReadEvaluationStateResponse> METHOD_READ_EVALUATION_STATE =
            EndpointDescriptor.<TReadEvaluationStateRequest, TReadEvaluationStateResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getReadEvaluationStateMethod())
                    .setDeadlineResolver(TReadEvaluationStateRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TReadEvaluationStateResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TReadEvaluationStatsRequest, TReadEvaluationStatsResponse> METHOD_READ_EVALUATION_STATS =
            EndpointDescriptor.<TReadEvaluationStatsRequest, TReadEvaluationStatsResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getReadEvaluationStatsMethod())
                    .setDeadlineResolver(TReadEvaluationStatsRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TReadEvaluationStatsResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TExplainEvaluationRequest, TExplainEvaluationResponse> METHOD_EXPLAIN_EVALUATION =
            EndpointDescriptor.<TExplainEvaluationRequest, TExplainEvaluationResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getExplainEvaluationMethod())
                    .setDeadlineResolver(TExplainEvaluationRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TExplainEvaluationResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TSimulateEvaluationRequest, TSimulateEvaluationResponse> METHOD_SIMULATE_EVALUATION =
            EndpointDescriptor.<TSimulateEvaluationRequest, TSimulateEvaluationResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getSimulateEvaluationMethod())
                    .setDeadlineResolver(TSimulateEvaluationRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TSimulateEvaluationResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TReadNotificationStateRequest, TReadNotificationStateResponse> METHOD_READ_NOTIFICATION_STATE =
            EndpointDescriptor.<TReadNotificationStateRequest, TReadNotificationStateResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getReadNotificationStateMethod())
                    .setDeadlineResolver(TReadNotificationStateRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TReadNotificationStateResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TReadNotificationStatsRequest, TReadNotificationStatsResponse> METHOD_READ_NOTIFICATION_STATS =
            EndpointDescriptor.<TReadNotificationStatsRequest, TReadNotificationStatsResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getReadNotificationStatsMethod())
                    .setDeadlineResolver(TReadNotificationStatsRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TReadNotificationStatsResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TReadProjectStatsRequest, TReadProjectStatsResponse> METHOD_READ_PROJECT_STATS =
            EndpointDescriptor.<TReadProjectStatsRequest, TReadProjectStatsResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getReadProjectStatsMethod())
                    .setDeadlineResolver(TReadProjectStatsRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TReadProjectStatsResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TCreateNotificationRequest, TCreateNotificationResponse> METHOD_CREATE_NOTIFICATION =
            EndpointDescriptor.<TCreateNotificationRequest, TCreateNotificationResponse>newBuilder()
                    .setGrpcMethod(TNotificationServiceGrpc.getCreateNotificationMethod())
                    .setDeadlineResolver(TCreateNotificationRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TCreateNotificationResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TReadNotificationRequest, TReadNotificationResponse> METHOD_READ_NOTIFICATION =
            EndpointDescriptor.<TReadNotificationRequest, TReadNotificationResponse>newBuilder()
                    .setGrpcMethod(TNotificationServiceGrpc.getReadNotificationMethod())
                    .setDeadlineResolver(TReadNotificationRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TReadNotificationResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TUpdateNotificationRequest, TUpdateNotificationResponse> METHOD_UPDATE_NOTIFICATION =
            EndpointDescriptor.<TUpdateNotificationRequest, TUpdateNotificationResponse>newBuilder()
                    .setGrpcMethod(TNotificationServiceGrpc.getUpdateNotificationMethod())
                    .setDeadlineResolver(TUpdateNotificationRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TUpdateNotificationResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TDeleteNotificationRequest, TDeleteNotificationResponse> METHOD_DELETE_NOTIFICATION =
            EndpointDescriptor.<TDeleteNotificationRequest, TDeleteNotificationResponse>newBuilder()
                    .setGrpcMethod(TNotificationServiceGrpc.getDeleteNotificationMethod())
                    .setDeadlineResolver(TDeleteNotificationRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TDeleteNotificationResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TListNotificationsRequest, TListNotificationsResponse> METHOD_LIST_NOTIFICATION =
            EndpointDescriptor.<TListNotificationsRequest, TListNotificationsResponse>newBuilder()
                    .setGrpcMethod(TNotificationServiceGrpc.getListNotificationsMethod())
                    .setDeadlineResolver(TListNotificationsRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TListNotificationsResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TResolveNotificationDetailsRequest, TResolveNotificationDetailsResponse> METHOD_RESOLVE_NOTIFICATION_DETAILS =
            EndpointDescriptor.<TResolveNotificationDetailsRequest, TResolveNotificationDetailsResponse>newBuilder()
                    .setGrpcMethod(TNotificationServiceGrpc.getResolveNotificationDetailsMethod())
                    .setDeadlineResolver(TResolveNotificationDetailsRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TResolveNotificationDetailsResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TListEscalationsRequest, TListEscalationsResponse> METHOD_LIST_ESCALATIONS =
            EndpointDescriptor.<TListEscalationsRequest, TListEscalationsResponse>newBuilder()
                    .setGrpcMethod(TNotificationServiceGrpc.getListEscalationsMethod())
                    .setDeadlineResolver(TListEscalationsRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TListEscalationsResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TTelegramGroupTitlesRequest, TTelegramGroupTitlesResponse> METHOD_GET_TELEGRAM_GROUP_TITLE =
            EndpointDescriptor.<TTelegramGroupTitlesRequest, TTelegramGroupTitlesResponse>newBuilder()
                    .setGrpcMethod(TTelegramServiceGrpc.getTelegramGroupTitlesMethod())
                    .setDeadlineResolver(TTelegramGroupTitlesRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TTelegramGroupTitlesResponse::getRequestStatus)
                    .build();

    static final EndpointDescriptor<TYaChatsGroupsRequest, TYaChatsGroupsResponse> METHOD_GET_YACHAT_GROUPS =
            EndpointDescriptor.<TYaChatsGroupsRequest, TYaChatsGroupsResponse>newBuilder()
                    .setGrpcMethod(TYaChatsServiceGrpc.getYaChatsGroupsMethod())
                    .setDeadlineResolver(TYaChatsGroupsRequest::getDeadlineMillis)
                    .setStatusCodeResolver(TYaChatsGroupsResponse::getRequestStatus)
                    .build();

    /*
    Mute service methods pass deadline explicitly, not in the request message.
    Also, there is no application-level status, so map all responses to OK.
    */
    static final EndpointDescriptor<CreateMuteRequest, CreateMuteResponse> METHOD_CREATE_MUTE =
            EndpointDescriptor.<CreateMuteRequest, CreateMuteResponse>newBuilder()
                    .setGrpcMethod(MuteServiceGrpc.getCreateMuteMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<ReadMuteRequest, ReadMuteResponse> METHOD_READ_MUTE =
            EndpointDescriptor.<ReadMuteRequest, ReadMuteResponse>newBuilder()
                    .setGrpcMethod(MuteServiceGrpc.getReadMuteMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<UpdateMuteRequest, UpdateMuteResponse> METHOD_UPDATE_MUTE =
            EndpointDescriptor.<UpdateMuteRequest, UpdateMuteResponse>newBuilder()
                    .setGrpcMethod(MuteServiceGrpc.getUpdateMuteMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<DeleteMuteRequest, DeleteMuteResponse> METHOD_DELETE_MUTE =
            EndpointDescriptor.<DeleteMuteRequest, DeleteMuteResponse>newBuilder()
                    .setGrpcMethod(MuteServiceGrpc.getDeleteMuteMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<ListMutesRequest, ListMutesResponse> METHOD_LIST_MUTES =
            EndpointDescriptor.<ListMutesRequest, ListMutesResponse>newBuilder()
                    .setGrpcMethod(MuteServiceGrpc.getListMutesMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<ReadMuteStatsRequest, ReadMuteStatsResponse> METHOD_READ_MUTE_STATS =
            EndpointDescriptor.<ReadMuteStatsRequest, ReadMuteStatsResponse>newBuilder()
                    .setGrpcMethod(MuteServiceGrpc.getReadMuteStatsMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<ReadAlertTemplateRequest, ReadAlertTemplateResponse> METHOD_READ_TEMPLATE =
            EndpointDescriptor.<ReadAlertTemplateRequest, ReadAlertTemplateResponse>newBuilder()
                    .setGrpcMethod(AlertTemplateServiceGrpc.getReadAlertTemplateMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<ListAlertTemplateRequest, ListAlertTemplateResponse> METHOD_LIST_TEMPLATES =
            EndpointDescriptor.<ListAlertTemplateRequest, ListAlertTemplateResponse>newBuilder()
                    .setGrpcMethod(AlertTemplateServiceGrpc.getListAlertTemplateMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<ListAlertTemplateVersionsRequest, ListAlertTemplateVersionsResponse> METHOD_LIST_TEMPLATE_VERSIONS =
            EndpointDescriptor.<ListAlertTemplateVersionsRequest, ListAlertTemplateVersionsResponse>newBuilder()
                    .setGrpcMethod(AlertTemplateServiceGrpc.getListAlertTemplateVersionsMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<PublishAlertTemplateRequest, PublishAlertTemplateResponse> METHOD_PUBLISH_TEMPLATE =
            EndpointDescriptor.<PublishAlertTemplateRequest, PublishAlertTemplateResponse>newBuilder()
                    .setGrpcMethod(AlertTemplateServiceGrpc.getPublishAlertTemplateMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<DeleteAlertTemplatePublicationRequest, DeleteAlertTemplatePublicationResponse> METHOD_UNPUBLISH_TEMPLATE =
            EndpointDescriptor.<DeleteAlertTemplatePublicationRequest, DeleteAlertTemplatePublicationResponse>newBuilder()
                    .setGrpcMethod(AlertTemplateServiceGrpc.getDeleteAlertTemplatePublicationMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<DeployAlertTemplateRequest, DeployAlertTemplateResponse> METHOD_DEPLOY_TEMPLATE =
            EndpointDescriptor.<DeployAlertTemplateRequest, DeployAlertTemplateResponse>newBuilder()
                    .setGrpcMethod(AlertTemplateServiceGrpc.getDeployAlertTemplateMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<UpdateAlertTemplateVersionRequest, UpdateAlertTemplateVersionResponse> METHOD_UPDATE_ALERT_TEMPLATE_VERSION =
            EndpointDescriptor.<UpdateAlertTemplateVersionRequest, UpdateAlertTemplateVersionResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getUpdateAlertTemplateVersionMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<CreateAlertTemplateRequest, CreateAlertTemplateResponse> METHOD_CREATE_TEMPLATE =
            EndpointDescriptor.<CreateAlertTemplateRequest, CreateAlertTemplateResponse>newBuilder()
                    .setGrpcMethod(AlertTemplateServiceGrpc.getCreateAlertTemplateMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<CreateAlertsFromTemplateRequest, CreateAlertsFromTemplateResponse> METHOD_CREATE_TEMPLATE_ALERTS =
            EndpointDescriptor.<CreateAlertsFromTemplateRequest, CreateAlertsFromTemplateResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getCreateAlertsFromTemplateMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();

    static final EndpointDescriptor<ListAlertLabelsRequest, ListAlertLabelsResponse> METHOD_liST_ALERT_LABELS =
            EndpointDescriptor.<ListAlertLabelsRequest, ListAlertLabelsResponse>newBuilder()
                    .setGrpcMethod(TAlertServiceGrpc.getListAlertLabelsMethod())
                    .setDeadlineResolver(ignore -> 0L)
                    .setStatusCodeResolver(ignore -> ERequestStatusCode.OK)
                    .build();
}
