package ru.yandex.solomon.alert.client.grpc;

import java.util.concurrent.CompletableFuture;

import javax.annotation.WillNotClose;

import ru.yandex.solomon.alert.client.TelegramApi;
import ru.yandex.solomon.alert.protobuf.TTelegramGroupTitlesRequest;
import ru.yandex.solomon.alert.protobuf.TTelegramGroupTitlesResponse;


/**
 * @author alexlovkov
 **/
public class TelegramClient implements TelegramApi {
    private final AlertingCluster cluster;

    public TelegramClient(@WillNotClose AlertingCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public CompletableFuture<TTelegramGroupTitlesResponse> getTelegramGroupTitles(
        TTelegramGroupTitlesRequest request)
    {
        return cluster.execute(EndpointDescriptors.METHOD_GET_TELEGRAM_GROUP_TITLE, request);
    }
}
