package ru.yandex.solomon.alert.client.grpc;

import java.util.concurrent.CompletableFuture;

import javax.annotation.WillNotClose;

import ru.yandex.solomon.alert.client.YaChatsApi;
import ru.yandex.solomon.alert.protobuf.TYaChatsGroupsRequest;
import ru.yandex.solomon.alert.protobuf.TYaChatsGroupsResponse;

/**
 * @author Nikita Minin
 */
public class YaChatsClient implements YaChatsApi {
    private final AlertingCluster cluster;

    public YaChatsClient(@WillNotClose AlertingCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public CompletableFuture<TYaChatsGroupsResponse> getYaChatsGroups(
        TYaChatsGroupsRequest request)
    {
        return cluster.execute(EndpointDescriptors.METHOD_GET_YACHAT_GROUPS, request);
    }
}
