package ru.yandex.solomon.alert.client.stub;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.alert.client.AlertApi;
import ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateRequest;
import ru.yandex.solomon.alert.protobuf.CreateAlertsFromTemplateResponse;
import ru.yandex.solomon.alert.protobuf.ListAlertLabelsRequest;
import ru.yandex.solomon.alert.protobuf.ListAlertLabelsResponse;
import ru.yandex.solomon.alert.protobuf.TCreateAlertRequest;
import ru.yandex.solomon.alert.protobuf.TCreateAlertResponse;
import ru.yandex.solomon.alert.protobuf.TDeleteAlertRequest;
import ru.yandex.solomon.alert.protobuf.TDeleteAlertResponse;
import ru.yandex.solomon.alert.protobuf.TDeletionNotificationRequest;
import ru.yandex.solomon.alert.protobuf.TDeletionNotificationResponse;
import ru.yandex.solomon.alert.protobuf.TExplainEvaluationRequest;
import ru.yandex.solomon.alert.protobuf.TExplainEvaluationResponse;
import ru.yandex.solomon.alert.protobuf.TListAlertRequest;
import ru.yandex.solomon.alert.protobuf.TListAlertResponse;
import ru.yandex.solomon.alert.protobuf.TListSubAlertRequest;
import ru.yandex.solomon.alert.protobuf.TListSubAlertResponse;
import ru.yandex.solomon.alert.protobuf.TReadAlertInterpolatedRequest;
import ru.yandex.solomon.alert.protobuf.TReadAlertInterpolatedResponse;
import ru.yandex.solomon.alert.protobuf.TReadAlertRequest;
import ru.yandex.solomon.alert.protobuf.TReadAlertResponse;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStateRequest;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStateResponse;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStatsRequest;
import ru.yandex.solomon.alert.protobuf.TReadEvaluationStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStateRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStateResponse;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStatsRequest;
import ru.yandex.solomon.alert.protobuf.TReadNotificationStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadProjectStatsRequest;
import ru.yandex.solomon.alert.protobuf.TReadProjectStatsResponse;
import ru.yandex.solomon.alert.protobuf.TReadSubAlertRequest;
import ru.yandex.solomon.alert.protobuf.TReadSubAlertResponse;
import ru.yandex.solomon.alert.protobuf.TSimulateEvaluationRequest;
import ru.yandex.solomon.alert.protobuf.TSimulateEvaluationResponse;
import ru.yandex.solomon.alert.protobuf.TUpdateAlertRequest;
import ru.yandex.solomon.alert.protobuf.TUpdateAlertResponse;
import ru.yandex.solomon.alert.protobuf.UpdateAlertTemplateVersionRequest;
import ru.yandex.solomon.alert.protobuf.UpdateAlertTemplateVersionResponse;

/**
 * @author Vladimir Gordiychuk
 */
public abstract class AbstractAlertApi implements AlertApi {
    @Override
    public CompletableFuture<TCreateAlertResponse> createAlert(TCreateAlertRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TReadAlertResponse> readAlert(TReadAlertRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TReadAlertInterpolatedResponse> readAlert(TReadAlertInterpolatedRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TReadSubAlertResponse> readSubAlert(TReadSubAlertRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TUpdateAlertResponse> updateAlert(TUpdateAlertRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TDeleteAlertResponse> deleteAlert(TDeleteAlertRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TDeletionNotificationResponse> notifyOnDeletionProject(TDeletionNotificationRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TListAlertResponse> listAlerts(TListAlertRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TListSubAlertResponse> listSubAlerts(TListSubAlertRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TReadEvaluationStateResponse> readEvaluationState(TReadEvaluationStateRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TReadEvaluationStatsResponse> readEvaluationStats(TReadEvaluationStatsRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TExplainEvaluationResponse> explainEvaluation(TExplainEvaluationRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TSimulateEvaluationResponse> simulateEvaluation(TSimulateEvaluationRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TReadNotificationStateResponse> readNotificationState(TReadNotificationStateRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TReadNotificationStatsResponse> readNotificationStats(TReadNotificationStatsRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<TReadProjectStatsResponse> readProjectStats(TReadProjectStatsRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<UpdateAlertTemplateVersionResponse> updateAlertTemplateVersion(UpdateAlertTemplateVersionRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<CreateAlertsFromTemplateResponse> createAlerts(CreateAlertsFromTemplateRequest request) {
        return notSupported();
    }

    @Override
    public CompletableFuture<ListAlertLabelsResponse> listAlertLabels(ListAlertLabelsRequest request) {
        return notSupported();
    }

    private static <T> CompletableFuture<T> notSupported() {
        return CompletableFuture.failedFuture(new UnsupportedOperationException("not implemented"));
    }
}
