package ru.yandex.solomon.auth;

import java.util.Optional;

import ru.yandex.solomon.auth.openid.OpenIdSubject;

/**
 * @author Sergey Polovko
 */
public interface AuthSubject {

    String getUniqueId();

    AuthType getAuthType();

    // XXX: temporary hack, remove when https://st.yandex-team.ru/SOLOMON-5899 will be closed
    static Optional<String> getLogin(AuthSubject subject) {
        if (subject instanceof OpenIdSubject) {
            return ((OpenIdSubject) subject).getLogin();
        }
        return Optional.of(subject.getUniqueId());
    }

    static String getLogin(AuthSubject subject, String defaultValue) {
        return getLogin(subject).orElse(defaultValue);
    }
}
