package ru.yandex.solomon.auth;

import java.util.Objects;


/**
 * @author Sergey Polovko
 */
public class AuthToken {

    private final AuthType type;
    private final String value;

    public AuthToken(AuthType type, String value) {
        this.type = Objects.requireNonNull(type);
        this.value = Objects.requireNonNull(value);
    }

    public AuthType getType() {
        return type;
    }

    public String getValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AuthToken authToken = (AuthToken) o;
        return type == authToken.type && value.equals(authToken.value);
    }

    @Override
    public int hashCode() {
        return type.hashCode() * 31 + value.hashCode();
    }

    @Override
    public String toString() {
        return type + "{" + value + '}';
    }
}
