package ru.yandex.solomon.auth;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public interface AuthorizationObject {

    static AuthorizationObject classic(String projectId, String folderId) {
        return new ClassicAuthorizationObject(projectId, folderId);
    }

    static AuthorizationObject serviceProvider(String serviceProviderId, @Nullable String objectId) {
        return new SpAuthorizationObject(serviceProviderId, objectId);
    }

    static AuthorizationObject abc(String abcSlug, String roleScopeSlug) {
        return new AbcAuthorizationObject(abcSlug, roleScopeSlug);
    }

    Type getType();

    @ParametersAreNonnullByDefault
    record ClassicAuthorizationObject(String projectId, String folderId) implements AuthorizationObject {
        @Override
        public Type getType() {
            return Type.CLASSIC;
        }
    }

    @ParametersAreNonnullByDefault
    record SpAuthorizationObject(String serviceProviderId, @Nullable String objectId) implements AuthorizationObject {
        @Override
        public Type getType() {
            return Type.SERVICE_PROVIDER;
        }
    }

    @ParametersAreNonnullByDefault
    record AbcAuthorizationObject(String abcSlug, String roleScopeSlug) implements AuthorizationObject {
        @Override
        public Type getType() {
            return Type.ABC;
        }
    }

    @ParametersAreNonnullByDefault
    enum Type {
        CLASSIC("project", "projectId"),
        SERVICE_PROVIDER("service_provider", "serviceProviderId"),
        ABC("abc", "abc_slug"),
        ;

        private final String name;
        private final String idName;

        Type(String name, String idName) {
            this.name = name;
            this.idName = idName;
        }

        public String getName() {
            return name;
        }

        public String getIdName() {
            return idName;
        }
    }
}
