package ru.yandex.solomon.auth;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableSet;

/**
 * @author Alexey Trushkin
 */
public record AuthorizationObjects(Set<AuthorizationObject> objectIds) {

    public static final AuthorizationObjects EMPTY = new AuthorizationObjects(Set.of());

    public static AuthorizationObjects of(Set<AuthorizationObject> objects) {
        return objects.isEmpty()
                ? EMPTY
                : new AuthorizationObjects(objects);
    }

    public Set<AuthorizationObject.ClassicAuthorizationObject> getClassicObjects() {
        return objectIds.stream()
                .filter(authorizationObject -> authorizationObject.getType() == AuthorizationObject.Type.CLASSIC)
                .map(authorizationObject -> (AuthorizationObject.ClassicAuthorizationObject) authorizationObject)
                .collect(Collectors.toSet());
    }

    public AuthorizationObjects combine(AuthorizationObjects authorizationObjects) {
        if (this == EMPTY && authorizationObjects == EMPTY) {
            return EMPTY;
        }
        if (this == EMPTY) {
            return authorizationObjects;
        }
        if (authorizationObjects == EMPTY) {
            return this;
        }
        Set<AuthorizationObject> vals = new HashSet<>(objectIds.size() + authorizationObjects.objectIds.size());
        vals.addAll(objectIds);
        vals.addAll(authorizationObjects.objectIds);
        return new AuthorizationObjects(ImmutableSet.copyOf(vals));
    }
}
