package ru.yandex.solomon.auth;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.auth.roles.Permission;
import ru.yandex.solomon.auth.roles.Role;

/**
 * @author Alexey Trushkin
 */
public class AuthorizerDelegate implements Authorizer {
    private final Authorizer delegate;

    public AuthorizerDelegate(Authorizer delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean canAuthorize(AuthSubject subject) {
        return delegate.canAuthorize(subject);
    }

    @Override
    public boolean canAuthorizeObject(AuthorizationObject object) {
        return delegate.canAuthorizeObject(object);
    }

    @Override
    public CompletableFuture<Account> authorize(AuthSubject subject, String projectId, String folderId, Permission permission) {
        return delegate.authorize(subject, projectId, folderId, permission);
    }

    @Override
    public CompletableFuture<Account> authorize(AuthSubject subject, String projectId, Permission permission) {
        return delegate.authorize(subject, projectId, permission);
    }

    @Override
    public CompletableFuture<Account> authorize(AuthSubject subject, AuthorizationObject authorizationObject, Permission permission) {
        return delegate.authorize(subject, authorizationObject, permission);
    }

    @Override
    public CompletableFuture<AuthorizationObjects> getAvailableAuthorizationObjects(AuthSubject subject, Set<Role> roles, EnumSet<AuthorizationObject.Type> types) {
        return delegate.getAvailableAuthorizationObjects(subject, roles, types);
    }
}
