package ru.yandex.solomon.auth.exceptions;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * @author Sergey Polovko
 */
@ResponseStatus(HttpStatus.UNAUTHORIZED)
public class AuthenticationException extends RuntimeException {

    private final String sessionState;
    private final String redirectTo;
    private final boolean needToResetSessionId;

    public AuthenticationException(String message) {
        this(message, false, false);
    }

    public AuthenticationException(String message, boolean redirectToPassport) {
        super(message, null, false, false);
        this.sessionState = "";
        this.redirectTo = redirectToPassport ? "passport" : "";
        this.needToResetSessionId = false;
    }

    public AuthenticationException(String message, String redirectTo, String sessionState) {
        super(message, null, false, false);
        this.sessionState = sessionState;
        this.redirectTo = redirectTo;
        this.needToResetSessionId = false;
    }

    public AuthenticationException(String message, boolean redirectToPassport, boolean needToResetSessionId) {
        super(message, null, false, false);
        this.sessionState = "";
        this.redirectTo = redirectToPassport ? "passport" : "";
        this.needToResetSessionId = needToResetSessionId;
    }

    public AuthenticationException(String message, Throwable cause) {
        super(message, cause, false, false);
        this.sessionState = "";
        this.redirectTo = "";
        this.needToResetSessionId = false;
    }

    public String getRedirectTo() {
        return redirectTo;
    }

    public boolean isNeedToResetSessionId() {
        return needToResetSessionId;
    }

    public String getSessionState() {
        return sessionState;
    }
}
