package ru.yandex.solomon.auth.fake;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import io.grpc.Attributes;
import io.grpc.Metadata;
import org.springframework.http.server.reactive.ServerHttpRequest;

import ru.yandex.solomon.auth.AnonymousAuthSubject;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthToken;
import ru.yandex.solomon.auth.AuthType;
import ru.yandex.solomon.auth.Authenticator;

/**
 * @author Sergey Polovko
 */
public class AnonymousAuthenticator implements Authenticator {

    private static final AuthToken FAKE_TOKEN = new AuthToken(AuthType.Anonymous, "user");

    @Override
    public Optional<AuthToken> getToken(ServerHttpRequest request) {
        return Optional.of(FAKE_TOKEN);
    }

    @Override
    public Optional<AuthToken> getToken(Metadata headers, Attributes attributes) {
        return Optional.of(FAKE_TOKEN);
    }

    @Override
    public CompletableFuture<AuthSubject> authenticate(AuthToken token) {
        return CompletableFuture.completedFuture(AnonymousAuthSubject.INSTANCE);
    }
}
