package ru.yandex.solomon.auth.fake;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.auth.Account;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthorizationObject;
import ru.yandex.solomon.auth.Authorizer;
import ru.yandex.solomon.auth.roles.Permission;

/**
 * @author Sergey Polovko
 */
public class AnonymousAuthorizer implements Authorizer {

    @Override
    public boolean canAuthorize(AuthSubject subject) {
        return true;
    }

    @Override
    public boolean canAuthorizeObject(AuthorizationObject object) {
        return true;
    }

    @Override
    public CompletableFuture<Account> authorize(
            AuthSubject subject, AuthorizationObject authorizationObject, Permission permission)
    {
        return CompletableFuture.completedFuture(Account.ANONYMOUS);
    }

}
