package ru.yandex.solomon.auth.http;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class OptionalAuthMetrics {
    public static final OptionalAuthMetrics INSTANCE = new OptionalAuthMetrics();

    private final MetricRegistry metricRegistry;

    private OptionalAuthMetrics() {
        this.metricRegistry = MetricRegistry.root();
    }

    public void register(String handler, AuthSubject authSubject) {
        String type = authSubject.getAuthType().name();
        Labels labels = Labels.of("handler", handler, "type", type);
        metricRegistry.rate("optionalAuth.requests.total", labels).inc();
        // For backward comparatively
        metricRegistry.rate("oldAuth.requests", labels).inc();
    }
}
