package ru.yandex.solomon.auth.iam;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.http.server.reactive.ServerHttpRequest;
import yandex.cloud.auth.api.AsyncCloudAuthClient;
import yandex.cloud.auth.api.credentials.ApiKey;

import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthType;
import ru.yandex.solomon.auth.exceptions.AuthenticationException;
import ru.yandex.solomon.auth.http.AuthHeaderHelper;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ApiKeyAuthenticator {
    private final AsyncCloudAuthClient authClient;

    public ApiKeyAuthenticator(AsyncCloudAuthClient authClient) {
        this.authClient = authClient;
    }

    public CompletableFuture<AuthSubject> getToken(ServerHttpRequest request) {
        if (AuthHeaderHelper.hasValidHeader(AuthType.IAM, request)) {
            String token = AuthHeaderHelper.getAuthToken(AuthType.IAM, request);
            var result = new CompletableFuture<AuthSubject>();
            authClient.authenticate(new ApiKey(token))
                    .whenComplete((s, t) -> {
                        try {
                            if (t != null) {
                                var cause = CompletableFutures.unwrapCompletionException(t);
                                result.completeExceptionally(new AuthenticationException(cause.getMessage(), cause));
                            } else {
                                result.complete(new IamSubject(s));
                            }
                        } catch (Throwable x) {
                            result.completeExceptionally(x);
                        }
                    });
            return result;
        }
        return CompletableFuture.failedFuture(new AuthenticationException("cannot authenticate request"));
    }
}
