package ru.yandex.solomon.auth.iam;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

import yandex.cloud.auth.api.AsyncCloudAuthClient;
import yandex.cloud.auth.api.Resource;
import yandex.cloud.auth.api.Subject;
import yandex.cloud.auth.api.credentials.AbstractCredentials;


/**
 * @author Sergey Polovko
 */
public class FakeCloudAuthClient implements AsyncCloudAuthClient {

    @Override
    public CompletableFuture<Subject> authenticate(AbstractCredentials credentials) {
        return CompletableFuture.failedFuture(new UnsupportedOperationException("unreachable"));
    }

    @Override
    public CompletableFuture<Subject> authorize(
        AbstractCredentials credentials, String permission, Stream<Resource> path)
    {
        return CompletableFuture.failedFuture(new UnsupportedOperationException("unreachable"));
    }

    @Override
    public CompletableFuture<Subject> authorize(Subject.Id subjectId, String permission, Stream<Resource> path) {
        return CompletableFuture.failedFuture(new UnsupportedOperationException("unreachable"));
    }
}
