package ru.yandex.solomon.auth.local;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import io.grpc.Attributes;
import io.grpc.Metadata;
import org.springframework.http.server.reactive.ServerHttpRequest;

import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthToken;
import ru.yandex.solomon.auth.AuthType;
import ru.yandex.solomon.auth.Authenticator;
import ru.yandex.solomon.auth.http.AuthHeaderHelper;


/**
 * @author Sergey Polovko
 */
public class AsUserAuthenticator implements Authenticator {

    @Override
    public Optional<AuthToken> getToken(ServerHttpRequest request) {
        if (AuthHeaderHelper.hasValidHeader(AuthType.AsUser, request)) {
            String login = AuthHeaderHelper.getAuthToken(AuthType.AsUser, request);
            return Optional.of(new AuthToken(AuthType.AsUser, login));
        }
        return Optional.empty();
    }

    @Override
    public Optional<AuthToken> getToken(Metadata headers, Attributes attributes) {
        if (AuthHeaderHelper.hasValidHeader(AuthType.AsUser, headers)) {
            String login = AuthHeaderHelper.getAuthToken(AuthType.AsUser, headers);
            return Optional.of(new AuthToken(AuthType.AsUser, login));
        }
        return Optional.empty();
    }

    @Override
    public CompletableFuture<AuthSubject> authenticate(AuthToken token) {
        try {
            return CompletableFuture.completedFuture(new AsUserSubject(token.getValue()));
        } catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }
}
