package ru.yandex.solomon.auth.local;

import java.util.Objects;

import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthType;


/**
 * @author Sergey Polovko
 */
public class AsUserSubject implements AuthSubject {

    private final String login;

    public AsUserSubject(String login) {
        this.login = Objects.requireNonNull(login, "login");
    }

    @Override
    public String getUniqueId() {
        return login;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.AsUser;
    }

    public String getLogin() {
        return login;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AsUserSubject that = (AsUserSubject) o;

        return login.equals(that.login);
    }

    @Override
    public int hashCode() {
        return login.hashCode();
    }

    @Override
    public String toString() {
        return "AsUserSubject{login='" + login + "\'}";
    }
}
