package ru.yandex.solomon.auth.oauth;

import java.util.Objects;

import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthType;


/**
 * @author Sergey Polovko
 */
public class OAuthSubject implements AuthSubject {

    private final long uid;
    private final String login;

    public OAuthSubject(long uid, String login) {
        this.uid = uid;
        this.login = Objects.requireNonNull(login, "login");
    }

    @Override
    public String getUniqueId() {
        return login;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.OAuth;
    }

    public long getUid() {
        return uid;
    }

    public String getLogin() {
        return login;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OAuthSubject that = (OAuthSubject) o;

        if (uid != that.uid) return false;
        return login.equals(that.login);
    }

    @Override
    public int hashCode() {
        int result = (int) (uid ^ (uid >>> 32));
        result = 31 * result + login.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "OAuthSubject{uid=" + uid + ", login='" + login + "\'}";
    }
}
