package ru.yandex.solomon.auth.oauth;

import java.util.Arrays;

import ru.yandex.solomon.auth.AuthToken;
import ru.yandex.solomon.auth.AuthType;


/**
 * @author Sergey Polovko
 */
public class OAuthToken extends AuthToken {

    private final String userIp;
    private final String[] scopes;

    public OAuthToken(String token, String userIp, String[] scopes) {
        super(AuthType.OAuth, token);
        this.userIp = userIp;
        this.scopes = scopes;
    }

    public String getUserIp() {
        return userIp;
    }

    public String[] getScopes() {
        return scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OAuthToken that = (OAuthToken) o;
        return getValue().equals(that.getValue()) &&
            userIp.equals(that.userIp) &&
            Arrays.equals(scopes, that.scopes);
    }

    @Override
    public int hashCode() {
        int result = getType().hashCode();
        result = 31 * result + getValue().hashCode();
        result = 31 * result + userIp.hashCode();
        result = 31 * result + Arrays.hashCode(scopes);
        return result;
    }

    @Override
    public String toString() {
        return "OAuthToken{token='" + getValue() + ", userIp='" + userIp + "', scopes=" + Arrays.toString(scopes) + '}';
    }
}
