package ru.yandex.solomon.auth.openid;

import ru.yandex.solomon.auth.AuthToken;
import ru.yandex.solomon.auth.AuthType;
import ru.yandex.solomon.util.collection.Nullables;
import ru.yandex.solomon.util.http.HttpUtils;

/**
 * @author Sergey Polovko
 */
public class OpenIdAuthToken extends AuthToken {

    // all cookies from HTTP-request
    private final String cookieHeader;

    public OpenIdAuthToken(String cookieHeader) {
        // use only 'yc_session' cookie as a key, to avoid cache misses
        super(AuthType.OpenId, Nullables.orEmpty(HttpUtils.cookieValue(cookieHeader, OpenIdCookies.YC_SESSION)));
        this.cookieHeader = cookieHeader;
    }

    public String getCookieHeader() {
        return cookieHeader;
    }
}
