package ru.yandex.solomon.auth.openid;

import java.util.concurrent.TimeUnit;

import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;

/**
 * @author Sergey Polovko
 */
public interface OpenIdCookies {

    String YC_SESSION = "yc_session";

    String YC_SESSION_STATE = "yc_session_state";

    static String saveSessionState(String state) {
        DefaultCookie cookie = new DefaultCookie(OpenIdCookies.YC_SESSION_STATE, state);
        cookie.setMaxAge(TimeUnit.MINUTES.toSeconds(5)); // 5min
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setPath("/");
        return ServerCookieEncoder.LAX.encode(cookie);
    }

    static String removeSessionState() {
        DefaultCookie cookie = new DefaultCookie(OpenIdCookies.YC_SESSION_STATE, "");
        cookie.setMaxAge(-1);     // already expired
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setPath("/");
        return ServerCookieEncoder.LAX.encode(cookie);
    }
}
