package ru.yandex.solomon.auth.openid;

import java.util.Optional;

import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthType;

/**
 * @author Sergey Polovko
 */
public class OpenIdSubject implements AuthSubject {

    private final String accountId;
    private final Optional<String> login;

    public OpenIdSubject(String accountId, Optional<String> login) {
        this.accountId = accountId;
        this.login = login;
    }

    @Override
    public String getUniqueId() {
        return accountId;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.OpenId;
    }

    public String getAccountId() {
        return accountId;
    }

    public Optional<String> getLogin() {
        return login;
    }

    @Override
    public String toString() {
        var sb = new StringBuilder("OpenIdSubject{accountId='").append(accountId);
        login.ifPresent(l -> sb.append("', login='").append(l));
        return sb.append("'}").toString();
    }
}
