package ru.yandex.solomon.auth.roles;

/**
 * @author Sergey Polovko
 */
public enum Permission {
    CONFIGS_LIST("configs.list"),
    CONFIGS_GET("configs.get"),
    CONFIGS_CREATE("configs.create"),
    CONFIGS_UPDATE("configs.update"),
    CONFIGS_DELETE("configs.delete"),
    CONFIGS_UPDATE_ANY("configs.updateAny"),
    CONFIGS_UPDATE_INTERNALS("configs.updateInternals"),
    PROJECTS_DELETE("projects.delete"),

    ROLES_UPDATE("roles.update"),

    METRICS_GET("sensors.get"),
    METRIC_LABELS_GET("sensorLabels.get"),
    METRIC_NAMES_GET("sensorNames.get"),

    DATA_READ("data.read"),
    DATA_WRITE("data.write"),
    DATA_WRITE_DATAPROC("data.writeDataProc"),

    QUOTA_GET("quota.get"),
    QUOTA_UPDATE("quota.update"),

    UI_GOD("ui.god"),
    UI_BETA("ui.beta"),

    ALERT_MANAGEMENT("alerts.update"),
    ALERT_TEMPLATE_MANAGEMENT("alertTemplates.update"),

    MUTES_GET("mutes.get"),
    MUTES_CREATE("mutes.create"),
    MUTES_DELETE("mutes.delete"),
    MUTES_UPDATE("mutes.update"),

    JNS_NOTIFICATION_SEND("notifications.send", "jns."),
    JNS_NOTIFICATION_GET("notifications.get", "jns."),
    ;
    public static final Permission[] ALL = values();
    private final String slug;

    Permission(String slug) {
        this(slug, "monitoring.");
    }

    Permission(String slug, String slugPrefix) {
        this.slug = slugPrefix + slug;
    }

    public String getSlug() {
        return slug;
    }

    public static Permission fromString(String slug) {
        for (Permission p : ALL) {
            if (p.getSlug().equalsIgnoreCase(slug)) {
                return p;
            }
        }
        return null;
    }
}
