package ru.yandex.solomon.auth.roles;

import java.util.EnumSet;


/**
 * @author Sergey Polovko
 */
public enum Role {

    // -- project roles -----------------------------------

    VIEWER(
        Permission.CONFIGS_LIST,
        Permission.CONFIGS_GET,
        Permission.METRICS_GET,
        Permission.METRIC_LABELS_GET,
        Permission.METRIC_NAMES_GET,
        Permission.DATA_READ,
        Permission.MUTES_GET
    ),

    EDITOR(
        Permission.CONFIGS_CREATE,
        Permission.CONFIGS_UPDATE,
        Permission.CONFIGS_DELETE,
        Permission.CONFIGS_LIST,
        Permission.CONFIGS_GET,
        Permission.METRICS_GET,
        Permission.METRIC_LABELS_GET,
        Permission.METRIC_NAMES_GET,
        Permission.DATA_READ,
        Permission.MUTES_GET,
        Permission.MUTES_CREATE,
        Permission.MUTES_DELETE,
        Permission.MUTES_UPDATE,
        Permission.JNS_NOTIFICATION_SEND,
        Permission.JNS_NOTIFICATION_GET
    ),

    PUSHER(
        Permission.DATA_WRITE
    ),

    PROJECT_ADMIN(
        Permission.CONFIGS_LIST,
        Permission.CONFIGS_GET,
        Permission.METRICS_GET,
        Permission.METRIC_LABELS_GET,
        Permission.METRIC_NAMES_GET,
        Permission.DATA_READ,
        Permission.CONFIGS_CREATE,
        Permission.CONFIGS_UPDATE,
        Permission.CONFIGS_DELETE,
        Permission.DATA_WRITE,
        Permission.ROLES_UPDATE,
        Permission.MUTES_GET,
        Permission.MUTES_CREATE,
        Permission.MUTES_DELETE,
        Permission.MUTES_UPDATE,
        Permission.JNS_NOTIFICATION_SEND,
        Permission.JNS_NOTIFICATION_GET
    ),

    MUTER(
        Permission.CONFIGS_LIST,
        Permission.CONFIGS_GET,
        Permission.MUTES_GET,
        Permission.MUTES_CREATE,
        Permission.MUTES_DELETE,
        Permission.MUTES_UPDATE
    ),

    // -- service provider roles --------------------------

    SERVICE_PROVIDER_ADMIN(
        Permission.ALERT_MANAGEMENT,
        Permission.ALERT_TEMPLATE_MANAGEMENT
    ),

    SERVICE_PROVIDER_ALERT_EDITOR(
        Permission.ALERT_MANAGEMENT
    ),

    // -- system roles ------------------------------------
    JNS_SENDER(
        Permission.JNS_NOTIFICATION_SEND,
        Permission.JNS_NOTIFICATION_GET
    ),

    // -- system roles ------------------------------------

    PROJECT_DELETER(
        Permission.PROJECTS_DELETE
    ),

    BETA_TESTER(
        Permission.UI_BETA
    ),

    ADMIN(
        Permission.CONFIGS_UPDATE_ANY,
        Permission.CONFIGS_UPDATE_INTERNALS,
        Permission.QUOTA_GET,
        Permission.QUOTA_UPDATE,
        Permission.UI_GOD,
        Permission.CONFIGS_LIST,
        Permission.CONFIGS_GET,
        Permission.METRICS_GET,
        Permission.METRIC_LABELS_GET,
        Permission.METRIC_NAMES_GET,
        Permission.DATA_READ,
        Permission.CONFIGS_CREATE,
        Permission.CONFIGS_UPDATE,
        Permission.CONFIGS_DELETE,
        Permission.DATA_WRITE,
        Permission.ROLES_UPDATE,
        Permission.MUTES_GET,
        Permission.MUTES_CREATE,
        Permission.MUTES_DELETE,
        Permission.MUTES_UPDATE,
        Permission.ALERT_MANAGEMENT,
        Permission.ALERT_TEMPLATE_MANAGEMENT,
        Permission.PROJECTS_DELETE,
        Permission.JNS_NOTIFICATION_SEND,
        Permission.JNS_NOTIFICATION_GET
    ),
    ;

    public static final Role[] PROJECT_ROLES = { VIEWER, EDITOR, PUSHER, PROJECT_ADMIN, MUTER, JNS_SENDER };
    public static final Role[] SYSTEM_ROLES = { BETA_TESTER, ADMIN, PROJECT_DELETER };
    public static final Role[] ALL_ROLES = values();

    private final EnumSet<Permission> permissions;

    Role(Permission first, Permission... rest) {
        this.permissions = EnumSet.of(first, rest);
    }

    public EnumSet<Permission> getPermissions() {
        return permissions;
    }

    public boolean has(Permission p) {
        return permissions.contains(p);
    }

    public static EnumSet<Permission> joinPermissions(EnumSet<Role> roles) {
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (Role role : roles) {
            permissions.addAll(role.getPermissions());
        }
        return permissions;
    }

    public static Role fromString(String role) {
        for (Role r : ALL_ROLES) {
            if (r.name().equalsIgnoreCase(role)) {
                return r;
            }
        }
        return null;
    }
}
