package ru.yandex.solomon.auth.roles;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;

import javax.annotation.concurrent.Immutable;


/**
 * @author Sergey Polovko
 */
@Immutable
public class RoleSet {

    public static final RoleSet EMPTY = new RoleSet();
    public static final RoleSet SYSTEM_ALL = new RoleSet(Role.SYSTEM_ROLES);
    public static final RoleSet PROJECT_ALL = new RoleSet(Role.PROJECT_ROLES);
    public static final RoleSet PROJECT_VIEW_AND_PUSH = new RoleSet(Role.VIEWER, Role.PUSHER);
    public static final RoleSet PROJECT_VIEW = new RoleSet(Role.VIEWER);
    public static final RoleSet ALL = new RoleSet(Role.ALL_ROLES);

    private final EnumSet<Role> roles;
    private final EnumSet<Permission> permissions;

    private RoleSet() {
        this.roles = EnumSet.noneOf(Role.class);
        this.permissions = EnumSet.noneOf(Permission.class);
    }

    private RoleSet(Role... roles) {
        this(Arrays.asList(roles));
    }

    private RoleSet(Collection<Role> roles) {
        this.roles = EnumSet.copyOf(roles);
        this.permissions = Role.joinPermissions(this.roles);
    }

    public static RoleSet of(Role... roles) {
        if (roles.length == 0) {
            return EMPTY;
        }
        return new RoleSet(roles);
    }

    public static RoleSet of(Collection<Role> roles) {
        if (roles.isEmpty()) {
            return EMPTY;
        }
        return new RoleSet(roles);
    }

    public boolean hasRole(Role r) {
        return roles.contains(r);
    }

    public boolean hasPermission(Permission p) {
        return permissions.contains(p);
    }

    public EnumSet<Role> toEnumSet() {
        return EnumSet.copyOf(roles);
    }

    @Override
    public String toString() {
        return roles.toString();
    }
}
