package ru.yandex.solomon.auth.sessionid;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.AuthType;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class SessionIdAuthSubject implements AuthSubject {
    private final String login;

    public SessionIdAuthSubject(String login) {
        this.login = login;
    }

    @Override
    public String getUniqueId() {
        return login;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.SessionIdCookie;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionIdAuthSubject)) {
            return false;
        }

        SessionIdAuthSubject that = (SessionIdAuthSubject) o;

        return login.equals(that.login);
    }

    @Override
    public int hashCode() {
        return login.hashCode();
    }

    @Override
    public String toString() {
        return "SessionIdAuthSubject{login='" + login + "'}";
    }
}
