package ru.yandex.solomon.auth.sessionid;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.auth.AuthToken;
import ru.yandex.solomon.auth.AuthType;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class SessionIdAuthToken extends AuthToken {
    private final String sessionId;
    private final String sslSessionId;
    private final String userIp;

    public SessionIdAuthToken(String sessionId, String sslSessionId, String userIp) {
        super(AuthType.SessionIdCookie, sessionId);
        this.sessionId = sessionId;
        this.sslSessionId = sslSessionId;
        this.userIp = userIp;
    }

    public String getSessionId() {
        return sessionId;
    }

    public String getSslSessionId() {
        return sslSessionId;
    }

    public String getUserIp() {
        return userIp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionIdAuthToken)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }

        SessionIdAuthToken that = (SessionIdAuthToken) o;

        if (!sessionId.equals(that.sessionId)) {
            return false;
        }
        if (!sslSessionId.equals(that.sslSessionId)) {
            return false;
        }
        return userIp.equals(that.userIp);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + sessionId.hashCode();
        result = 31 * result + sslSessionId.hashCode();
        result = 31 * result + userIp.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "SessionIdAuthToken{" +
            "sessionId='" + sessionId + '\'' +
            ", sslSessionId='" + sslSessionId + '\'' +
            ", userIp='" + userIp + '\'' +
            "} " + super.toString();
    }
}
