package ru.yandex.solomon.auth.tvm;

import java.util.regex.Pattern;


/**
 * @author Sergey Polovko
 */
public class FakeTvmLogin {
    private FakeTvmLogin() {}

    private static final Pattern PATTERN = Pattern.compile("tvm-\\d+");

    public static String forClientId(int clientId) {
        return "tvm-" + clientId;
    }

    public static boolean isValid(String login) {
        return PATTERN.matcher(login).matches();
    }
}
