package ru.yandex.solomon.auth.tvm;

import ru.yandex.solomon.auth.AuthToken;
import ru.yandex.solomon.auth.AuthType;


/**
 * @author Sergey Polovko
 */
public class TvmUserTicket extends AuthToken {

    private final String serviceTicket;
    private final String userIp;

    public TvmUserTicket(String userTicket, String serviceTicket, String userIp) {
        super(AuthType.TvmUser, userTicket);
        this.serviceTicket = serviceTicket;
        this.userIp = userIp;
    }

    public String getUserTicket() {
        return getValue();
    }

    public String getServiceTicket() {
        return serviceTicket;
    }

    public String getUserIp() {
        return userIp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TvmUserTicket that = (TvmUserTicket) o;
        return getUserTicket().equals(that.getUserTicket()) &&
            serviceTicket.equals(that.serviceTicket) &&
            userIp.equals(that.userIp);
    }

    @Override
    public int hashCode() {
        int result = getType().hashCode();
        result = 31 * result + getUserTicket().hashCode();
        result = 31 * result + serviceTicket.hashCode();
        result = 31 * result + userIp.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "TvmUserTicket{user='" + getUserTicket() + "', service='" + serviceTicket + ", userIp='" + userIp + "'}";
    }
}
