package ru.yandex.solomon.auth;

import java.util.Set;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Sergey Polovko
 */
public class SolomonTeamTest {

    @Test
    public void emptyFile() {
        var team = SolomonTeam.parse("");
        Assert.assertEquals(Set.of(), team);
    }

    @Test
    public void emptyLines() {
        var team = SolomonTeam.parse("    \n  \n\n");
        Assert.assertEquals(Set.of(), team);
    }

    @Test
    public void oneMember() {
        Assert.assertEquals(Set.of("jamel"), SolomonTeam.parse("jamel"));
        Assert.assertEquals(Set.of("jamel"), SolomonTeam.parse("jamel\n"));
        Assert.assertEquals(Set.of("jamel"), SolomonTeam.parse("\njamel"));
        Assert.assertEquals(Set.of("jamel"), SolomonTeam.parse("\njamel\n"));
        Assert.assertEquals(Set.of("jamel"), SolomonTeam.parse(" \n  jamel  \n "));
    }

    @Test
    public void multipleMembers() {
        Assert.assertEquals(Set.of("jamel", "knuzhdin"), SolomonTeam.parse("jamel\nknuzhdin"));
        Assert.assertEquals(Set.of("jamel", "knuzhdin"), SolomonTeam.parse("knuzhdin\njamel"));
        Assert.assertEquals(Set.of("jamel", "knuzhdin"), SolomonTeam.parse("knuzhdin\njamel\n"));
        Assert.assertEquals(Set.of("jamel", "knuzhdin"), SolomonTeam.parse("\nknuzhdin\njamel\n"));
        Assert.assertEquals(Set.of("jamel", "knuzhdin"), SolomonTeam.parse(" \n jamel \n knuzhdin \n "));
    }

    @Test
    public void comments() {
        {
            String content =
                    "1 # jamel\n" +
                    "2 # knuzhdin\n";
            Assert.assertEquals(Set.of("1", "2"), SolomonTeam.parse(content));
        }
        {
            String content =
                    "1#jamel\n" +
                    "2#knuzhdin\n";
            Assert.assertEquals(Set.of("1", "2"), SolomonTeam.parse(content));
        }
        {
            String content =
                    "# dev\n" +
                    "1 # jamel\n" +
                    "# ops\n" +
                    "2 # knuzhdin\n";
            Assert.assertEquals(Set.of("1", "2"), SolomonTeam.parse(content));
        }
    }
}
