package ru.yandex.solomon.balancer;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.MoreObjects;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AssignmentSeqNo implements Comparable<AssignmentSeqNo> {
    public static AssignmentSeqNo EMPTY = new AssignmentSeqNo(0, 0);

    private final long leaderSeqNo;
    private final long assignSeqNo;

    public AssignmentSeqNo(long leaderSeqNo, long assignSeqNo) {
        this.leaderSeqNo = leaderSeqNo;
        this.assignSeqNo = assignSeqNo;
    }

    public long getLeaderSeqNo() {
        return leaderSeqNo;
    }

    public long getAssignSeqNo() {
        return assignSeqNo;
    }

    public int compareLeaderSeqNo(AssignmentSeqNo seqNo) {
        return compareLeaderSeqNo(leaderSeqNo, seqNo.leaderSeqNo);
    }

    public int compareAssignSeqNo(AssignmentSeqNo seqNo) {
        return compareAssignSeqNo(assignSeqNo, seqNo.assignSeqNo);
    }

    @Override
    public int compareTo(AssignmentSeqNo seqNo) {
        int compare = compareLeaderSeqNo(seqNo);
        if (compare == 0) {
            compare = compareAssignSeqNo(seqNo);
        }
        return compare;
    }

    public static int compareLeaderSeqNo(long left, long right) {
        return Long.compareUnsigned(left, right);
    }

    public static int compareAssignSeqNo(long left, long right) {
        return Long.compareUnsigned(left, right);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AssignmentSeqNo seqNo = (AssignmentSeqNo) o;

        if (leaderSeqNo != seqNo.leaderSeqNo) return false;
        return assignSeqNo == seqNo.assignSeqNo;
    }

    @Override
    public int hashCode() {
        int result = (int) (leaderSeqNo ^ (leaderSeqNo >>> 32));
        result = 31 * result + (int) (assignSeqNo ^ (assignSeqNo >>> 32));
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("leaderSeqNo", leaderSeqNo)
                .add("assignSeqNo", assignSeqNo)
                .toString();
    }
}
