package ru.yandex.solomon.balancer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import javax.annotation.Nullable;

/**
 * @author Vladimir Gordiychuk
 */
public interface Balancer extends AutoCloseable {

    @Nullable
    String getAutoFreezeReason();

    double getDispersion();

    Map<String, NodeSummary> getNodes();

    AssignmentSeqNo getLatestSeqNo();

    Map<String, ShardSummary> getShards();

    CompletableFuture<String> getOrCreateAssignment(String shardId);

    CompletableFuture<String> getAssignment(String shardId);

    CompletableFuture<?> kickShard(String shardId);

    CompletableFuture<?> kickNode(String address);

    CompletableFuture<?> setActive(String address, boolean flag);

    CompletableFuture<?> setActive(boolean flag);

    CompletableFuture<?> setFreeze(boolean flag);

    CompletableFuture<?> setFreeze(String address, boolean value);

    CompletableFuture<?> setOptions(BalancerOptions opts);

    BalancerOptions getOptions();

    Resources getResourceMaximum();

    List<Resource> getResources();

    CompletableFuture<?> rebalance();

    CompletableFuture<?> cancelRebalance();

    double getRebalanceProgress();

    void run(Runnable task);

    <T> CompletableFuture<T> runAsync(Supplier<CompletableFuture<T>> supplier);

    <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier);

    @Override
    void close();
}
