package ru.yandex.solomon.balancer;

import java.util.Collection;

/**
 * Resource used by balancer to choose node
 *
 * @author Vladimir Gordiychuk
 */
public interface Resource {
    /**
     * Human readable resource name
     */
    String name();

    default String prettyName() {
        return name();
    }

    default String prettyValue(double value) {
        return Double.toString(value);
    }

    double maximum(Collection<ShardSummary> shards, Collection<NodeSummary> nodes);
}
