package ru.yandex.solomon.balancer;

import java.util.concurrent.atomic.AtomicInteger;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public class TotalShardCounterImpl implements TotalShardCounter {

    private final AtomicInteger counter = new AtomicInteger(SHARD_COUNT_UNKNOWN);

    @Override
    public void reset() {
        counter.set(SHARD_COUNT_UNKNOWN);
    }

    @Override
    public void setTotalShardCount(int totalShardCount) {
        counter.set(totalShardCount);
    }

    @Override
    public int getTotalShardCount() {
        return counter.get();
    }
}
