package ru.yandex.solomon.balancer.dao;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.balancer.BalancerOptions;
import ru.yandex.solomon.balancer.snapshot.SnapshotAssignments;

/**
 * @author Vladimir Gordiychuk
 */
public interface BalancerDao {
    CompletableFuture<Void> createSchema();

    CompletableFuture<BalancerOptions> getOptions();
    CompletableFuture<Void> saveOptions(BalancerOptions opts);

    CompletableFuture<SnapshotAssignments> getAssignments();
    CompletableFuture<Void> saveAssignments(SnapshotAssignments assignments);
}
