package ru.yandex.solomon.balancer.dao;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.balancer.BalancerOptions;
import ru.yandex.solomon.balancer.snapshot.SnapshotAssignments;

/**
 * @author Vladimir Gordiychuk
 */
public class InMemoryBalancerDao implements BalancerDao {
    private volatile SnapshotAssignments assignments;
    private volatile BalancerOptions opts;

    @Override
    public CompletableFuture<BalancerOptions> getOptions() {
        return CompletableFuture.supplyAsync(() -> {
            var copy = opts;
            if (copy != null) {
                return copy;
            } else {
                return BalancerOptions.newBuilder().build();
            }
        });
    }

    @Override
    public CompletableFuture<SnapshotAssignments> getAssignments() {
        return CompletableFuture.supplyAsync(() -> {
            var copy = assignments;
            if (copy != null) {
                return copy;
            } else {
                return SnapshotAssignments.EMPTY;
            }
        });
    }

    @Override
    public CompletableFuture<Void> saveAssignments(SnapshotAssignments assignments) {
        return CompletableFuture.supplyAsync(() -> {
            this.assignments = assignments;
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> saveOptions(BalancerOptions opts) {
        return CompletableFuture.supplyAsync(() -> {
            this.opts = opts;
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> createSchema() {
        return CompletableFuture.completedFuture(null);
    }
}
