package ru.yandex.solomon.balancer.dao;

import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.balancer.BalancerOptions;
import ru.yandex.solomon.balancer.snapshot.SnapshotAssignments;

/**
 * @author Vladimir Gordiychuk
 */
public class MigrateBalancerDao implements BalancerDao {
    private final BalancerDao source;
    private final BalancerDao target;

    public MigrateBalancerDao(BalancerDao source, BalancerDao target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public CompletableFuture<Void> createSchema() {
        return CompletableFuture.allOf(source.createSchema(), target.createSchema())
            .thenCompose(ignore -> source.getOptions())
            .thenCompose(target::saveOptions);
    }

    @Override
    public CompletableFuture<BalancerOptions> getOptions() {
        return source.getOptions();
    }

    @Override
    public CompletableFuture<SnapshotAssignments> getAssignments() {
        return source.getAssignments();
    }

    @Override
    public CompletableFuture<Void> saveAssignments(SnapshotAssignments assignments) {
        return source.saveAssignments(assignments)
            .thenCompose(ignore -> target.saveAssignments(assignments));
    }

    @Override
    public CompletableFuture<Void> saveOptions(BalancerOptions opts) {
        return source.saveOptions(opts)
            .thenCompose(ignore -> target.saveOptions(opts));
    }
}
