package ru.yandex.solomon.balancer.dao;

import com.yandex.ydb.table.description.TableDescription;
import com.yandex.ydb.table.values.PrimitiveType;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbBalancerTable {
    static final String COPY_QUERY = """
            --!syntax_v1
            DECLARE $srcKey AS Utf8;
            DECLARE $dstKey AS Utf8;
            DECLARE $now AS Timestamp;

            $to_move = (
                SELECT $dstKey as key, chunkNo, chunkCount, $now as createdAt, bytes
                FROM `${balancer.table.path}`
                WHERE key = $srcKey
            );

            DELETE FROM `${balancer.table.path}`
            WHERE key = $dstKey;

            UPSERT INTO `${balancer.table.path}`
            SELECT * FROM $to_move;
            """;

    static final String DELETE_QUERY = """
            --!syntax_v1
            DECLARE $key AS Utf8;

            DELETE FROM `${balancer.table.path}`
            WHERE key = $key;
            """;

    static final String PUT_QUERY = """
            --!syntax_v1
            DECLARE $key AS Utf8;
            DECLARE $bytes AS String;
            DECLARE $chunkNo AS Int32;
            DECLARE $chunkCount AS Int32;
            DECLARE $createdAt AS Timestamp;

            UPSERT INTO `${balancer.table.path}` (
              key,
              bytes,
              chunkNo,
              chunkCount,
              createdAt
            )
            VALUES (
              $key,
              $bytes,
              $chunkNo,
              $chunkCount,
              $createdAt
            );
            """;

    static TableDescription description() {
        return TableDescription.newBuilder()
                .addNullableColumn("key", PrimitiveType.utf8())
                .addNullableColumn("chunkNo", PrimitiveType.int32())
                .addNullableColumn("chunkCount", PrimitiveType.int32())
                .addNullableColumn("createdAt", PrimitiveType.timestamp())
                .addNullableColumn("bytes", PrimitiveType.string())
                .setPrimaryKeys("key", "chunkNo")
                .build();
    }
}
