package ru.yandex.solomon.balancer.dao;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbBlobQuery {
    private static final String INSERT_CHUNK = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $index AS Uint32;
            DECLARE $count AS Uint32;
            DECLARE $value AS String;
            DECLARE $now AS Timestamp;

            INSERT INTO `CHUNK_TABLE`(id, index, count, value, created_at, deleted_at)
            VALUES ($id, $index, $count, $value, $now, $now);
            """;

    private static final String DELETE_CHUNK = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $index AS Uint32;

            DELETE FROM `CHUNK_TABLE`
            WHERE id = $id AND index = $index;
            """;

    private static final String SELECT_INDEX = """
            --!syntax_v1
            DECLARE $key AS Utf8;

            SELECT * FROM `INDEX_TABLE` WHERE key = $key;
            """;

    private static final String INSERT_INDEX = """
            --!syntax_v1
            DECLARE $key AS Utf8;
            DECLARE $chunk_id AS Utf8;
            DECLARE $chunk_count AS Uint32;
            DECLARE $chunk_bytes AS Uint32;
            DECLARE $now AS Timestamp;

            $to_delete = (
                SELECT *
                FROM `INDEX_TABLE`
                WHERE key = $key AND chunk_id != $chunk_id
            );

            $obsolete_chunk_pks = (
                SELECT id as id, c.index as index
                FROM `CHUNK_TABLE` as c
                INNER JOIN $to_delete as i
                ON c.id = i.chunk_id
            );

            SELECT * FROM $to_delete;

            -- avoid remove new chunks
            UPDATE `CHUNK_TABLE` SET deleted_at = NULL WHERE id = $chunk_id;

            -- mark removed old chunks
            UPSERT INTO `CHUNK_TABLE`
            SELECT id, index, $now as deleted_at FROM $obsolete_chunk_pks;

            -- actualize reference to chunks
            UPSERT INTO `INDEX_TABLE`(key, chunk_id, chunk_count, chunk_bytes, created_at)
            VALUES ($key, $chunk_id, $chunk_count, $chunk_bytes, $now);
            """;

    private static final String DELETE_INDEX = """
            --!syntax_v1
            DECLARE $key AS Utf8;
            DECLARE $now AS Timestamp;

            $to_delete = (
                SELECT *
                FROM `INDEX_TABLE`
                WHERE key = $key
            );

            $obsolete_chunk_pks = (
                SELECT id as id, c.index as index
                FROM `CHUNK_TABLE` as c
                INNER JOIN $to_delete as i
                ON c.id = i.chunk_id
            );

            SELECT * FROM $to_delete;

            -- remove reference to chunks
            DELETE FROM `INDEX_TABLE` ON
            SELECT * FROM $to_delete;

            -- mark removed old chunks
            UPSERT INTO `CHUNK_TABLE`
            SELECT id, index, $now as deleted_at FROM $obsolete_chunk_pks;
            """;

    final String root;
    final String tableChunk;
    final String tableIndex;

    final String insertChunk;
    final String deleteChunk;

    final String selectIndex;
    final String insertIndex;
    final String deleteIndex;

    public YdbBlobQuery(String root, String prefix) {
        this.root = root;
        this.tableChunk = root + "/" + prefix + "Chunk";
        this.tableIndex = root + "/" + prefix + "Index";
        this.insertChunk = prepare(INSERT_CHUNK);
        this.deleteChunk = prepare(DELETE_CHUNK);
        this.selectIndex = prepare(SELECT_INDEX);
        this.insertIndex = prepare(INSERT_INDEX);
        this.deleteIndex = prepare(DELETE_INDEX);
    }

    private String prepare(String query) {
        return query
                .replaceAll("CHUNK_TABLE", tableChunk)
                .replaceAll("INDEX_TABLE", tableIndex);
    }
}
