package ru.yandex.solomon.balancer.remote;

import java.util.HashMap;
import java.util.Objects;
import java.util.Set;

/**
 * @author Vladimir Gordiychuk
 */
public class RemoteClusterStub implements RemoteCluster {
    private final HashMap<String, RemoteNode> unitByName = new HashMap<>();

    public synchronized void register(RemoteNode... nodes) {
        for (RemoteNode node : nodes) {
            this.unitByName.put(node.getAddress(), node);
        }
    }

    public synchronized void unregister(RemoteNode... nodes) {
        for (RemoteNode node : nodes) {
            this.unitByName.remove(node.getAddress(), node);
        }
    }

    @Override
    public synchronized boolean hasNode(String node) {
        return unitByName.containsKey(node);
    }

    @Override
    public synchronized Set<String> getNodes() {
        return Set.copyOf(unitByName.keySet());
    }

    @Override
    public void receiveHeartbeat(RemoteNodeState state) {

    }

    @Override
    public synchronized RemoteNode create(String address, long leaderSeqNo) {
        return Objects.requireNonNull(unitByName.get(address), "unknown node");
    }
}
