package ru.yandex.solomon.balancer.remote;

import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;

import ru.yandex.solomon.balancer.AssignmentSeqNo;

/**
 * @author Vladimir Gordiychuk
 */
public interface RemoteNode extends AutoCloseable {
    String getAddress();

    @Nullable
    RemoteNodeState takeState();

    CompletableFuture<Void> assignShard(String shardId, AssignmentSeqNo seqNo, long expiredAt);

    CompletableFuture<Void> unassignShard(String shardId, AssignmentSeqNo seqNo, boolean graceful, long expiredAt);

    double getFailCommandPercent();

    @Override
    void close();
}
